﻿using UnityEngine;
using System.Collections;
using System.Collections.Generic; // wymagane przez klasę Dictionary
using UnityEditor;

// To edytor dla klasy RuntimeColorChangers
[CustomEditor(typeof(RuntimeColorChanger))]
// Pozwala na jednoczesną edycję wielu obiektów
[CanEditMultipleObjects]
class RuntimeColorChangerEditor : Editor {

	// Kolekcja par łańcuch-kolor
	private Dictionary<string, Color> colorPresets;

	// Reprezentuje właściwość "color" wszystkich zaznaczonych obiektów
	private SerializedProperty colorProperty;

	// Metoda wywoływana podczas pierwszego wyświetlenia edytora
	public void OnEnable() {

		// Tworzymy listę predefiniowanych kolorów
		colorPresets = new Dictionary<string, Color>();

		colorPresets["czerwony"] = Color.red;
		colorPresets["zielony"] = Color.green;
		colorPresets["niebieski"] = Color.blue;
		colorPresets["żółty"] = Color.yellow;
		colorPresets["biały"] = Color.white;

		// Pobieramy właściwość z aktualnie zaznaczonego obiektu
		// (lub zaznaczonych obiektów)
		colorProperty = serializedObject.FindProperty("color");
	}

	// Metoda wywoływana w celu wyświetlenia GUI w panelu Inspector
	public override void OnInspectorGUI ()
	{
		// Zapewniamy, że obiekt serializedObject będzie aktualny
		serializedObject.Update();

		// Zaczynamy od utworzenia pionowej listy kontrolek
		using (var area = new EditorGUILayout.VerticalScope()) {

			// Dla każdego koloru na liście predefiniowanych kolorów...
			foreach (var preset in colorPresets) {

				// wyświetlamy przycisk
				var clicked = GUILayout.Button(preset.Key);

				// jeśli przycisk został kliknięty, to aktualizujemy właściwość
				if (clicked) {
					colorProperty.colorValue = preset.Value;
				}
			}

			// I w końcu wyświetlamy pole pozwalające na bezpośrednie
			// ustawienie koloru
			EditorGUILayout.PropertyField(colorProperty);
		}

		// Stosujemy zmiany wprowadzone we właściwości
		serializedObject.ApplyModifiedProperties();
	}
}
